<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

// [ 应用入口文件 ]
if (extension_loaded('zlib')){
	try{
	    ob_end_clean();
	} catch(Exception $e) {

	}
    ob_start('ob_gzhandler');
}
// 检测PHP环境
if(version_compare(PHP_VERSION,'5.4.0','<'))  die('require PHP > 5.4.0 !');
//error_reporting(E_ALL ^ E_NOTICE);//显示除去 E_NOTICE 之外的所有错误信息
error_reporting(E_ERROR | E_WARNING | E_PARSE);//报告运行时错误

//检测是否已安装EyouCMS系统
if(file_exists("./install/") && !file_exists("./install/install.lock")){
	if($_SERVER['PHP_SELF'] != '/index.php'){
		header("Content-type: text/html; charset=utf-8");         
		exit("请在域名根目录下安装,如:<br/> www.xxxxxx.com/index.php 正确 <br/>  www.xxxxxx.com/www/index.php 错误,域名后面不能圈套目录, 但项目没有根目录存放限制,可以放在任意目录,apache虚拟主机配置一下即可");
	}  
	header('Location:/install/index.php');
	exit(); 
}

// 当前是http还是https协议
$http = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] && $_SERVER['HTTPS'] != 'off') ? 'https' : 'http';
// 网站域名
define('DOMAIN', $_SERVER['HTTP_HOST']); 
// 带http/https网站域名
define('SITE_URL', $http.'://'.DOMAIN); 
// 不带前缀的域名-网站根域名
$pattern = '/^([^.]+)\.([^.]+)\.([^\/]+)$/';
$url_suffix = preg_replace($pattern, '$2.$3', DOMAIN);
define('ROOT_SITE_URL', '.'.$url_suffix);
//  临时数据绝对路径
define('DATA_PATH', __DIR__ . '/data/');
//  模板存储绝对路径
define('TEMPLATE_PATH', __DIR__ . '/template/');
//  定义插件绝对路径
define('PLUGIN_PATH', __DIR__ . '/plugins/');
// 编辑器图片上传相对路径
define('UPLOAD_PATH','public/upload/'); 
// 缓存时间
define('EYOUCMS_CACHE_TIME', 86400);
// http主域名
define('HTTPS_SITE_URL', 'https://'.DOMAIN);
//静态页面文件目录，存储静态页面文件
define('HTML_ROOT', __DIR__ . '/html/'); 
//静态页面文件目录，存储静态页面文件
define('HTML_PATH', HTML_ROOT . $http.'/'); 
//静态页面缓存文件目录，存储不指定文件名的静态页面文件
define('HTML_OTHER_PATH', HTML_PATH . 'other/'); 
//静态页面缓存文件目录， 存储cache方式的页面缓存
define('HTML_CACHE_PATH', HTML_PATH . 'cache/'); 
//静态文章列表页缓存时间 12小时
define('HTML_CACHE_LTIME', 43200);
//静态文章详情页缓存时间 24小时
define('HTML_CACHE_DTIME', 86400);
//安装程序定义
define('INSTALL_DATE',1495257240);
//序列号
define('SERIALNUMBER','20170520131400oCWIoa');
// 定义应用目录
define('APP_PATH', __DIR__ . '/application/');
// 定义时间
define('NOW_TIME',$_SERVER['REQUEST_TIME']);
// 阿里大鱼的日志存放路径
define('TOP_SDK_WORK_DIR', 'public/upload/tmp/');
// 加载框架引导文件
require __DIR__ . '/tpkernel/start.php';
